package javafxtest.input;

import java.io.InputStream;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.control.SkinBase;


public class OpenPatricianWoodenTextInputSkin extends SkinBase<OpenPatricianWoodenTextInput> {
	
	private DoubleProperty width = new SimpleDoubleProperty(this, "width", 0);
	private DoubleProperty height = new SimpleDoubleProperty(this, "height", 0);
	private ObjectProperty<Font> currentFont;
	
	private TextSizingUtility sizing = new TextSizingUtility();

	public OpenPatricianWoodenTextInputSkin(OpenPatricianWoodenTextInput input) {
		super(input);
		
		
		
		currentFont = new SimpleObjectProperty<Font>(this, "currentFont", input.getFont());
		Dimension2D dim = sizing.calculate(input.getSize(), currentFont.get());
		width.set(dim.getWidth());
		height.set(dim.getHeight());
		
		final TextField textField = new TextField(input.getText());
		textField.textProperty().bindBidirectional(input.textProperty());
		textField.getStyleClass().add("openPatricianWoodenTextInput");
		textField.setMaxSize(width.doubleValue(), height.doubleValue());
		
		final InputStream is = getClass().getResourceAsStream("InputPlank.jpg");
		Image img = new Image(is,width.doubleValue(), height.doubleValue(), false, true);
		final ImageView imgView = new ImageView(img);
		
		// Listeners
		input.sizeProperty().addListener(new ChangeListener<Number>() {

			@Override
			public void changed(ObservableValue<? extends Number> observable,
					Number oldValue, Number newValue) {
				Dimension2D dim = sizing.calculate((Integer)newValue, currentFont.get());
				width.set(dim.getWidth());
				textField.setMaxSize(width.doubleValue(), height.doubleValue());
				Image img = new Image(is,width.doubleValue(), height.doubleValue(), false, true);
				imgView.setImage(img);
			}
		});
		
		
		StackPane stack = new StackPane();
		stack.getChildren().addAll(imgView, textField);
		Group group = new Group(stack);
		group.setManaged(false);
		
		getChildren().add(group);
	}
	

}
